IF NOT OBJECT_ID('TRG_EST_NF_ENT_NFE_CANCEL_PEND') IS NULL 
	BEGIN 
		DROP TRIGGER TRG_EST_NF_ENT_NFE_CANCEL_PEND
	END

GO
------------------------------------INSERO EM EST_NF_ENT_NFE_PEND------------------------------------
CREATE TRIGGER [dbo].[TRG_EST_NF_ENT_NFE_CANCEL_PEND] ON [dbo].[EST_NF_ENT] FOR UPDATE AS
declare @inu int  
	--Se nao tem  nf cancelada sai da rotina
	if not exists (	select * from INSERTED WHERE STS_NF = 1)
		begin
			return;
		end
	if update(IGNORAR_GERACAO_FINAN) or update(DT_HR_CAD) or UPDATE(UUID)
		begin	
			return;
		end
	IF NOT EXISTS (SELECT P.CD_EMP 
					   FROM EST_NF_ENT_CANCEL_SOLIC P
							INNER JOIN inserted I ON 
								P.CD_EMP		= I.CD_EMP
								AND P.CD_FILIAL = I.CD_FILIAL 
								AND P.CD_NF		= I.CD_NF)
			BEGIN 		
				--Pendncia de entrada de nota fiscal eletronica
				INSERT INTO EST_NF_ENT_NFE_CANCEL_PEND (CD_EMP, CD_FILIAL, CD_NF)
				SELECT 
					t.CD_EMP, 
					t.CD_FILIAL, 
					t.CD_NF
				FROM 
    				INSERTED t 
					INNER JOIN EST_NF_SERIE sr_nf ON
					t.CD_EMP = sr_nf.CD_EMP  AND 
					t.CD_NF_SERIE = sr_nf.CD_NF_SERIE AND 
					sr_nf.TP_SR_NFE = 1
					INNER JOIN EST_NF_ENT_NFE NFE ON 
					T.CD_EMP = NFE.CD_EMP AND 
					T.CD_FILIAL = NFE.CD_FILIAL AND 
					T.CD_NF = NFE.CD_NF  
				WHERE 	
					t.STS_NF = 1			
					AND NOT EXISTS (SELECT 
										CD_EMP 
									FROM 
										EST_NF_ENT_NFE_CANCEL_PEND pend
									WHERE 
										t.CD_EMP      = pend.CD_EMP AND 
										t.CD_FILIAL   = pend.CD_FILIAL AND 
										t.CD_NF       = pend.CD_NF);
			END
	-- Caso a nota ainda nao tenha sido validada entao delata 
	DELETE  
		EST_NF_ENT_NFE_PEND 
	FROM 
		EST_NF_ENT_NFE_PEND PEND 
		INNER JOIN INSERTED t ON 
		T.CD_EMP = PEND.CD_EMP AND 
		T.CD_FILIAL = PEND.CD_FILIAL AND 
		T.CD_NF = PEND.CD_NF 	
	--Inutilizacao da numeracao
	INSERT INTO EST_NF_NFE_INU ( CD_EMP, CD_FILIAL, ANO, CD_MODELO, CD_NF_SERIE, CD_MOTIVO, NR_NF, DT_CAD,CD_USU)
	SELECT 
		t.CD_EMP, 
		t.CD_FILIAL, 
		YEAR(dt_emi_nf),
		55,
		t.CD_NF_SERIE,
		0,
		NR_NF,
		GETDATE(),
		t.CD_USU
	FROM 
    	INSERTED t 
		INNER JOIN EST_NF_SERIE sr_nf ON
		t.CD_EMP = sr_nf.CD_EMP  
		AND t.CD_NF_SERIE = sr_nf.CD_NF_SERIE 
		AND sr_nf.TP_SR_NFE = 1
		LEFT JOIN EST_NF_ENT_NFE NFE ON 
		T.CD_EMP = NFE.CD_EMP AND 
		T.CD_FILIAL = NFE.CD_FILIAL AND 
		T.CD_NF = NFE.CD_NF 
	WHERE 	
		t.STS_NF = 1			
		AND NFE.CD_EMP is null
		AND NOT EXISTS (SELECT 
							CD_EMP 
						FROM 
							EST_NF_NFE_INU pend
						WHERE 
							t.CD_EMP      = pend.CD_EMP AND 
							t.CD_FILIAL   = pend.CD_FILIAL AND 
							t.CD_NF_SERIE  = pend.CD_NF_SERIE AND
							t.NR_NF		=  pend.nr_nf);							
	SET @INU =(SELECT max(I.CD_INU)
				FROM 
    				INSERTED T
					INNER JOIN EST_NF_NFE_INU I on
					T.CD_EMP      = I.CD_EMP AND 
										T.CD_FILIAL   = I.CD_FILIAL AND 
										T.CD_NF_SERIE  = I.CD_NF_SERIE AND
										T.NR_NF		=  I.NR_NF);
	--SET @INU = @@IDENTITY 
	IF @INU IS NOT NULL
	BEGIN  
		--Pendencia de inutilizao da numeracao
		IF NOT EXISTS ( SELECT 1 FROM EST_NF_NFE_INU_PEND WHERE CD_INU = @INU ) 	
		 INSERT INTO EST_NF_NFE_INU_PEND (CD_INU,PEND_SOLUC,CD_EMP,CD_FILIAL) 		 
		 SELECT 
			@INU, 
			0 AS PEND_SOLUC, 
			INSERTED.CD_EMP, 
			INSERTED.CD_FILIAL  
		 FROM	
			INSERTED LEFT OUTER JOIN EST_NF_ENT_EST_NF_NFE_INU ON
			INSERTED.CD_EMP = EST_NF_ENT_EST_NF_NFE_INU.CD_EMP AND
			INSERTED.CD_FILIAL = EST_NF_ENT_EST_NF_NFE_INU.CD_FILIAL AND
			INSERTED.CD_NF = EST_NF_ENT_EST_NF_NFE_INU.CD_NF ;
		 INSERT INTO EST_NF_ENT_EST_NF_NFE_INU (CD_INU,CD_EMP,CD_FILIAL,CD_NF)
		 SELECT 
			@INU, 
			INSERTED.CD_EMP, 
			INSERTED.CD_FILIAL, 
			INSERTED.CD_NF  
		 FROM	
			INSERTED LEFT OUTER JOIN EST_NF_ENT_EST_NF_NFE_INU ON
			INSERTED.CD_EMP = EST_NF_ENT_EST_NF_NFE_INU.CD_EMP AND
			INSERTED.CD_FILIAL = EST_NF_ENT_EST_NF_NFE_INU.CD_FILIAL AND
			INSERTED.CD_NF = EST_NF_ENT_EST_NF_NFE_INU.CD_NF ;
		--Vinculo da nfe com a inutilizacao
		IF NOT EXISTS ( SELECT 1 FROM 
							EST_NF_NFE_INU_EF_NF_CTR_NR 
						WHERE CD_INU = @INU ) 
		BEGIN
			INSERT INTO EST_NF_NFE_INU_EF_NF_CTR_NR(CD_EMP,CD_FILIAL,NR_NF,CD_NF_SERIE,CD_INU) 
			SELECT 
				T.CD_EMP, 
				T.CD_FILIAL, 
				T.NR_NF,  
				T.CD_NF_SERIE, CD_INU 
			FROM 
				INSERTED T
				INNER JOIN  EST_NF_NFE_INU PEND ON 
				T.CD_EMP      = PEND.CD_EMP AND 
				T.CD_FILIAL   = PEND.CD_FILIAL AND 
				T.CD_NF_SERIE = PEND.CD_NF_SERIE AND
				T.NR_NF		  =  PEND.NR_NF
		END
	END 

